%     NITOOL     NATURE INSPIRED TOOLBOX

% ==============================================
%   PROGRAM AIM : Griewank Function
%     OUT = sum((x-100).^2,2)./4000 - ...
%            prod(cos((x-100)./(sqrt(repmat([1:N],length(x(:,1),1)))),2) ...
%            +1
% ==============================================
%   USAGE :
%         1. OUT = Griewank([1,2,5;6,0,-50])
%       Minima 0 at all x = 100
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function [out]=Griewank(in)
 persistent d D tlen sqrtd
% This speeds routine up a lot, if called from PSO these won't change from
% call to call

 Dx=length(in(1,:));
 tlenx=length(in(:,1));
 if isempty(D) | D~=Dx | tlen~=tlenx
   D=Dx; % dimension of prob
   tlen=tlenx; % how many separate states
   d=repmat([1:D],tlen,1); % needed to vectorize this
   sqrtd=sqrt(d);
 end

% just follows from the referenced website/paper
 term1 = sum([(in-100).^2],2)./4000;
 term2 = prod( (cos( (in-100)./sqrtd )) ,2);
 out = term1 - term2 + 1;